<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConfiguracionesTable extends Migration {

	public function up()
	{
		Schema::create('configuraciones', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('nombre');
			$table->string('apellidos')->index();
			$table->date('fecha_nacimiento');
			$table->string('telefono', 10);
			$table->enum('sexo', array('hombre', 'mujer'));
			$table->boolean('movil_certificado');
			$table->boolean('mail_certificado');
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('configuraciones');
	}
}