<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePuntosTable extends Migration {

	public function up()
	{
		Schema::create('puntos', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nombre')->unique();
			$table->string('direccion');
			$table->string('telefono', 10);
			$table->string('cod_postal', 5)->index();
			$table->string('horario');
			$table->softDeletes();
			$table->timestamps();
			$table->integer('localidad_id')->unsigned()->nullable();
			$table->integer('usuario_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('puntos');
	}
}