<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Envio extends Model 
{

    protected $table = 'envios';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function usuario()
    {
        return $this->belongsTo('Usuario');
    }

    public function destinatario()
    {
        return $this->hasOne('Persona', 'destinatario_id');
    }

    public function estado()
    {
        return $this->hasOne('Estado');
    }

    public function cobertura()
    {
        return $this->hasOne('Cobertura');
    }

    public function recogida()
    {
        return $this->hasOne('Puntos', 'punto_recogida_id');
    }

    public function entrega()
    {
        return $this->hasOne('Puntos', 'punto_entrega_id');
    }

    public function paquetes()
    {
        return $this->hasMany('Paquete');
    }

    public function metodoPago()
    {
        return $this->hasOne('Metodo', 'pago_id');
    }

}