<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePosicionTable extends Migration {

	public function up()
	{
		Schema::create('posicion', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('orden');
			$table->decimal('precio')->index();
			$table->datetime('hora')->index();
			$table->softDeletes();
			$table->integer('localidad_id')->unsigned()->nullable();
			$table->decimal('espacio_disponible', 4,2);
			$table->decimal('peso_disponible', 4,2);
			$table->integer('viaje_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('posicion');
	}
}