<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Personnel extends Model 
{

    protected $table = 'personnels';
    public $timestamps = true;
    protected $fillable = array('services_id', 'qualites_id', 'nomPersonnel', 'prenomPersonnel', 'sexe', 'dateDeNais');

    public function belongsTo()
    {
        return $this->belongsTo('Service', 'services_id');
    }

    public function belongsTo()
    {
        return $this->belongsTo('Equipe', 'equipe_id');
    }

    public function hasOne()
    {
        return $this->hasOne('Qualite', 'qualite_id');
    }

}