<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsTable extends Migration {

	public function up()
	{
		Schema::create('news', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('title');
			$table->text('image')->nullable();
			$table->text('link')->nullable();
			$table->text('body')->nullable();
			$table->string('status', 15)->default('active');
			$table->integer('position')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('news');
	}
}