<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAboutContentsTable extends Migration {

	public function up()
	{
		Schema::create('about_contents', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('about_id')->unsigned();
			$table->string('section_title')->nullable();
			$table->text('section_image')->nullable();
			$table->longText('section_body')->nullable();
			$table->string('status', 20)->default('active');
			$table->text('link')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('about_contents');
	}
}