<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateResearchCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('research_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->integer('lead')->unsigned();
			$table->text('experts')->nullable();
			$table->string('status', 20)->default('active');
		});
	}

	public function down()
	{
		Schema::drop('research_categories');
	}
}