<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MenuItemCategory extends Eloquent {

	protected $table = 'menu_item_categories';
	public $timestamps = false;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function menu_category()
	{
		return $this->hasOne('App\Models\MenuCategory');
	}

	public function menu_item()
	{
		return $this->belongsTo('App\Models\MenuItem');
	}

}