<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MenuItemIngredients extends Eloquent {

	protected $table = 'menu_item_ingredients';
	public $timestamps = false;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function ingredient()
	{
		return $this->belongsTo('App\Models\Ingredient');
	}

	public function menu_item()
	{
		return $this->hasOne('App\Models\MenuItem');
	}

}