<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MenuCategoryIngredients extends Eloquent {

	protected $table = 'menu_category_ingredients';
	public $timestamps = false;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function menu_category()
	{
		return $this->belongsTo('App\Models\MenuCategory');
	}

	public function ingredient()
	{
		return $this->hasOne('App\Models\Ingredient');
	}

}