<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeathsTable extends Migration {

	public function up()
	{
		Schema::create('deaths', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('patient_id')->unique()->unsigned();
			$table->enum('transed_out', array('yes', 'no'));
			$table->bigInteger('ward_id')->unsigned();
			$table->bigInteger('clinician_id')->unsigned();
			$table->enum('autopsy', array('yes', 'no'));
			$table->datetime('time_of_death');
			$table->enum('death_type', array('inpatient', 'outpatient', 'bid'));
			$table->bigInteger('opd_ipd_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('deaths');
	}
}