<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientTransfersTable extends Migration {

	public function up()
	{
		Schema::create('patient_transfers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('patient_id')->unsigned();
			$table->bigInteger('from_ward_id')->unsigned();
			$table->bigInteger('to_ward_id')->unsigned();
			$table->enum('staus', array('pending', 'accepted'));
			$table->bigInteger('transfered_by')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('patient_transfers');
	}
}