<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransfusionsTable extends Migration {

	public function up()
	{
		Schema::create('transfusions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('patient_id')->unsigned();
			$table->bigInteger('clinician_id')->unsigned();
			$table->integer('volume')->unsigned();
			$table->string('transfusion_product');
			$table->string('diagnoses_id');
			$table->decimal('haemoglobin', 2,1);
			$table->string('blood_group');
		});
	}

	public function down()
	{
		Schema::drop('transfusions');
	}
}