<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('lab_requests', function(Blueprint $table) {
			$table->foreign('lab_test_id')->references('id')->on('lab_tests')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('wards', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('beds', function(Blueprint $table) {
			$table->foreign('ward_id')->references('id')->on('wards')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->foreign('clinician_id')->references('id')->on('clinicians')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->foreign('medicine_id')->references('id')->on('medicines')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('consultations', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('consultations', function(Blueprint $table) {
			$table->foreign('procedure_type')->references('id')->on('opd_procedures')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('consultations', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('surgeries', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('surgeries', function(Blueprint $table) {
			$table->foreign('clinician_id')->references('id')->on('clinicians')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('surgeries', function(Blueprint $table) {
			$table->foreign('surgery_type_id')->references('id')->on('surgery_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('patient_bills', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('patient_transfers', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('patient_transfers', function(Blueprint $table) {
			$table->foreign('from_ward_id')->references('id')->on('wards')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('patient_transfers', function(Blueprint $table) {
			$table->foreign('to_ward_id')->references('id')->on('wards')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('discharges', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('discharges', function(Blueprint $table) {
			$table->foreign('ward_id')->references('id')->on('wards')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('discharges', function(Blueprint $table) {
			$table->foreign('clinician_id')->references('id')->on('clinicians')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('deaths', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('deaths', function(Blueprint $table) {
			$table->foreign('ward_id')->references('id')->on('wards')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('deaths', function(Blueprint $table) {
			$table->foreign('clinician_id')->references('id')->on('clinicians')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transfusions', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('transfusions', function(Blueprint $table) {
			$table->foreign('clinician_id')->references('id')->on('clinicians')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('admissions', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('admissions', function(Blueprint $table) {
			$table->foreign('clinician_id')->references('id')->on('clinicians')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('admissions', function(Blueprint $table) {
			$table->foreign('ward_id')->references('id')->on('wards')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('admissions', function(Blueprint $table) {
			$table->foreign('bed_id')->references('id')->on('beds')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('vitals', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('vitals', function(Blueprint $table) {
			$table->foreign('clinician_id')->references('id')->on('clinicians')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('opd_entries', function(Blueprint $table) {
			$table->foreign('clinician_id')->references('id')->on('clinicians')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('opd_entries', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('opd_entries', function(Blueprint $table) {
			$table->foreign('main_diagnosis_id')->references('id')->on('diagnoses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('patient_diagnosis', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('patient_diagnosis', function(Blueprint $table) {
			$table->foreign('clinician_id')->references('id')->on('clinicians')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('patient_diagnosis', function(Blueprint $table) {
			$table->foreign('diagnoses_id')->references('id')->on('diagnoses')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ipd_entries', function(Blueprint $table) {
			$table->foreign('clinician_id')->references('id')->on('clinicians')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ipd_entries', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('ipd_entries', function(Blueprint $table) {
			$table->foreign('admission_id')->references('id')->on('admissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fluids', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fluids', function(Blueprint $table) {
			$table->foreign('clinician_id')->references('id')->on('clinicians')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fluids', function(Blueprint $table) {
			$table->foreign('admission_id')->references('id')->on('admissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('lab_requests', function(Blueprint $table) {
			$table->dropForeign('lab_requests_lab_test_id_foreign');
		});
		Schema::table('wards', function(Blueprint $table) {
			$table->dropForeign('wards_department_id_foreign');
		});
		Schema::table('beds', function(Blueprint $table) {
			$table->dropForeign('beds_ward_id_foreign');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->dropForeign('prescriptions_patient_id_foreign');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->dropForeign('prescriptions_clinician_id_foreign');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->dropForeign('prescriptions_medicine_id_foreign');
		});
		Schema::table('consultations', function(Blueprint $table) {
			$table->dropForeign('consultations_patient_id_foreign');
		});
		Schema::table('consultations', function(Blueprint $table) {
			$table->dropForeign('consultations_procedure_type_foreign');
		});
		Schema::table('consultations', function(Blueprint $table) {
			$table->dropForeign('consultations_department_id_foreign');
		});
		Schema::table('surgeries', function(Blueprint $table) {
			$table->dropForeign('surgeries_patient_id_foreign');
		});
		Schema::table('surgeries', function(Blueprint $table) {
			$table->dropForeign('surgeries_clinician_id_foreign');
		});
		Schema::table('surgeries', function(Blueprint $table) {
			$table->dropForeign('surgeries_surgery_type_id_foreign');
		});
		Schema::table('patient_bills', function(Blueprint $table) {
			$table->dropForeign('patient_bills_patient_id_foreign');
		});
		Schema::table('patient_transfers', function(Blueprint $table) {
			$table->dropForeign('patient_transfers_patient_id_foreign');
		});
		Schema::table('patient_transfers', function(Blueprint $table) {
			$table->dropForeign('patient_transfers_from_ward_id_foreign');
		});
		Schema::table('patient_transfers', function(Blueprint $table) {
			$table->dropForeign('patient_transfers_to_ward_id_foreign');
		});
		Schema::table('discharges', function(Blueprint $table) {
			$table->dropForeign('discharges_patient_id_foreign');
		});
		Schema::table('discharges', function(Blueprint $table) {
			$table->dropForeign('discharges_ward_id_foreign');
		});
		Schema::table('discharges', function(Blueprint $table) {
			$table->dropForeign('discharges_clinician_id_foreign');
		});
		Schema::table('deaths', function(Blueprint $table) {
			$table->dropForeign('deaths_patient_id_foreign');
		});
		Schema::table('deaths', function(Blueprint $table) {
			$table->dropForeign('deaths_ward_id_foreign');
		});
		Schema::table('deaths', function(Blueprint $table) {
			$table->dropForeign('deaths_clinician_id_foreign');
		});
		Schema::table('transfusions', function(Blueprint $table) {
			$table->dropForeign('transfusions_patient_id_foreign');
		});
		Schema::table('transfusions', function(Blueprint $table) {
			$table->dropForeign('transfusions_clinician_id_foreign');
		});
		Schema::table('admissions', function(Blueprint $table) {
			$table->dropForeign('admissions_patient_id_foreign');
		});
		Schema::table('admissions', function(Blueprint $table) {
			$table->dropForeign('admissions_clinician_id_foreign');
		});
		Schema::table('admissions', function(Blueprint $table) {
			$table->dropForeign('admissions_ward_id_foreign');
		});
		Schema::table('admissions', function(Blueprint $table) {
			$table->dropForeign('admissions_bed_id_foreign');
		});
		Schema::table('vitals', function(Blueprint $table) {
			$table->dropForeign('vitals_patient_id_foreign');
		});
		Schema::table('vitals', function(Blueprint $table) {
			$table->dropForeign('vitals_clinician_id_foreign');
		});
		Schema::table('opd_entries', function(Blueprint $table) {
			$table->dropForeign('opd_entries_clinician_id_foreign');
		});
		Schema::table('opd_entries', function(Blueprint $table) {
			$table->dropForeign('opd_entries_patient_id_foreign');
		});
		Schema::table('opd_entries', function(Blueprint $table) {
			$table->dropForeign('opd_entries_main_diagnosis_id_foreign');
		});
		Schema::table('patient_diagnosis', function(Blueprint $table) {
			$table->dropForeign('patient_diagnosis_patient_id_foreign');
		});
		Schema::table('patient_diagnosis', function(Blueprint $table) {
			$table->dropForeign('patient_diagnosis_clinician_id_foreign');
		});
		Schema::table('patient_diagnosis', function(Blueprint $table) {
			$table->dropForeign('patient_diagnosis_diagnoses_id_foreign');
		});
		Schema::table('ipd_entries', function(Blueprint $table) {
			$table->dropForeign('ipd_entries_clinician_id_foreign');
		});
		Schema::table('ipd_entries', function(Blueprint $table) {
			$table->dropForeign('ipd_entries_patient_id_foreign');
		});
		Schema::table('ipd_entries', function(Blueprint $table) {
			$table->dropForeign('ipd_entries_admission_id_foreign');
		});
		Schema::table('fluids', function(Blueprint $table) {
			$table->dropForeign('fluids_patient_id_foreign');
		});
		Schema::table('fluids', function(Blueprint $table) {
			$table->dropForeign('fluids_clinician_id_foreign');
		});
		Schema::table('fluids', function(Blueprint $table) {
			$table->dropForeign('fluids_admission_id_foreign');
		});
	}
}