<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Department extends Eloquent {

	protected $table = 'departments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'gender_type');
	protected $visible = array('name', 'gender_type');

	public function wards()
	{
		return $this->hasMany('App\Ward');
	}

	public function consultations()
	{
		return $this->hasMany('App\Consultation');
	}

}