<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class LabRequest extends Eloquent {

	protected $table = 'lab_requests';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('lab_test_id', 'status');
	protected $visible = array('lab_test_id', 'status');

	public function labTest()
	{
		return $this->belongsTo('LabTest', 'id', 'lab_test_id');
	}

}