<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OPDEntry extends Eloquent {

	protected $table = 'opd_entries';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('clinician_id', 'patient_id', 'main_diagnosis_id', 'other_diagnosis', 'presenting_complaints', 'history_of_presenting_complaints');
	protected $visible = array('clinician_id', 'patient_id', 'main_diagnosis_id', 'other_diagnosis', 'presenting_complaints', 'history_of_presenting_complaints');

	public function patient()
	{
		return $this->belongsTo('App\Patient');
	}

	public function clinician()
	{
		return $this->belongsTo('App\Clinician');
	}

}