<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLabTestsTable extends Migration {

	public function up()
	{
		Schema::create('lab_tests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('test_name');
			$table->enum('payment_type', array('insurace', 'cash'));
			$table->decimal('price', 10,2);
			$table->enum('status', array('available', 'unavailable'));
		});
	}

	public function down()
	{
		Schema::drop('lab_tests');
	}
}