<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePrescriptionsTable extends Migration {

	public function up()
	{
		Schema::create('prescriptions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('patient_id')->unsigned();
			$table->bigInteger('clinician_id')->unsigned();
			$table->bigInteger('medicine_id')->unsigned();
			$table->string('dose');
			$table->string('route')->nullable();
			$table->enum('status', array('pending', 'fully_dispensed', 'partial_dispense'));
			$table->string('prescription_status');
			$table->enum('prescription_type', array('opd', 'ipd'));
			$table->bigInteger('opd_ipd_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('prescriptions');
	}
}