<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Restaurant extends Model 
{

    protected $table = 'restaurants';
    public $timestamps = true;

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function type()
    {
        return $this->belongsTo('App\RestaurantType');
    }

    public function orders()
    {
        return $this->hasMany('App\Order');
    }

    public function openingHours()
    {
        return $this->hasMany('App\OpeningHours');
    }

    public function deviatedOpeningHours()
    {
        return $this->hasMany('App\DeviatedOpeningHours');
    }

    public function information()
    {
        return $this->hasOne('App\RestaurantInformation');
    }

}