<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('quests', function(Blueprint $table) {
			$table->foreign('city')->references('id')->on('citys')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('quest')->references('id')->on('quests')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('day')->references('id')->on('days')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('days', function(Blueprint $table) {
			$table->foreign('price')->references('id')->on('prices')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('days', function(Blueprint $table) {
			$table->foreign('quest')->references('id')->on('quests')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('quests', function(Blueprint $table) {
			$table->dropForeign('quests_city_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_quest_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_day_foreign');
		});
		Schema::table('days', function(Blueprint $table) {
			$table->dropForeign('days_price_foreign');
		});
		Schema::table('days', function(Blueprint $table) {
			$table->dropForeign('days_quest_foreign');
		});
	}
}