<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGatewaysTable extends Migration {

	public function up()
	{
		Schema::create('gateways', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('ip', 15)->unique();
			$table->string('sn', 10)->unique();
			$table->string('version', 10);
			$table->string('devices_ip_scheme');
			$table->string('device_ip_scheme_ver', 10);
			$table->boolean('should_auto_update')->default(false);
			$table->integer('cinema_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('gateways');
	}
}