<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketLogsTable extends Migration {

	public function up()
	{
		Schema::create('ticket_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('ticket_id')->unsigned();
			$table->integer('sender_id')->unsigned();
			$table->integer('receiver_id')->unsigned();
			$table->tinyInteger('solution_type');
			$table->string('reason');
			$table->string('solution')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('ticket_logs');
	}
}