<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorsTable extends Migration {

	public function up()
	{
		Schema::create('vendors', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('email');
			$table->string('name');
			$table->string('offcial_name');
			$table->string('phone');
			$table->string('address');
			$table->string('Legal_papers');
			$table->enum('is_active', array('true', 'false'));
			$table->string('available');
			$table->float('holding');
			$table->float('total');
			$table->string('owner_name');
			$table->string('bank_name');
			$table->string('branch_name');
			$table->string('account_id');
			$table->string('iban');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vendors');
	}
}