<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOptionAttributeTable extends Migration {

	public function up()
	{
		Schema::create('option_attribute', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('option_id')->unsigned();
			$table->string('option_value');
			$table->integer('quantity');
			$table->float('additional_price')->nullable();
			$table->float('total_price')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('option_attribute');
	}
}