<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ticket extends Eloquent {

	protected $table = 'tickets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('message', 'client_id');

	public function client()
	{
		return $this->belongsTo('Client');
	}

}