<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerchantsTable extends Migration {

	public function up()
	{
		Schema::create('merchants', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name_ar')->nullable();
			$table->string('name_en')->nullable();
			$table->string('phone')->nullable();
			$table->string('address')->nullable();
			$table->string('image')->nullable();
			$table->integer('category_id')->unsigned();
			$table->enum('published', array('TRUE.FALSE'))->nullable();
			$table->string('commerical_number')->nullable();
			$table->boolean('status')->nullable();
			$table->string('commerical_img')->nullable();
			$table->string('type')->nullable();
			$table->string('latitude')->nullable();
			$table->string('longitude')->nullable();
			$table->integer('parent_id')->unsigned();
			$table->integer('employe_id')->nullable();
			$table->text('description_ar')->nullable();
			$table->text('description_en')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('merchants');
	}
}