<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('capon_id')->unsigned();
			$table->integer('address_id')->unsigned();
			$table->string('bill_number')->nullable();
			$table->enum('payment_status', array('Paid', 'NoPaid'))->nullable();
			$table->boolean('status')->nullable()->default(1);
			$table->string('total')->nullable();
			$table->string('subtotal')->nullable();
			$table->string('qrcode')->nullable();
			$table->string('payment_type')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}