<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('Roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('Address')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Attachments', function(Blueprint $table) {
			$table->foreign('userId')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Attachments', function(Blueprint $table) {
			$table->foreign('attachment_type')->references('id')->on('AttachmentTypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_role_id_foreign');
		});
		Schema::table('Users', function(Blueprint $table) {
			$table->dropForeign('Users_address_id_foreign');
		});
		Schema::table('Attachments', function(Blueprint $table) {
			$table->dropForeign('Attachments_userId_foreign');
		});
		Schema::table('Attachments', function(Blueprint $table) {
			$table->dropForeign('Attachments_attachment_type_foreign');
		});
	}
}