<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('employers', function(Blueprint $table) {
			$table->foreign('type')->references('id')->on('employer_type')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('employer_address', function(Blueprint $table) {
			$table->foreign('employer_id')->references('id')->on('employers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('employers', function(Blueprint $table) {
			$table->dropForeign('employers_type_foreign');
		});
		Schema::table('employer_address', function(Blueprint $table) {
			$table->dropForeign('employer_address_employer_id_foreign');
		});
	}
}