<?php

namespace App\Models;

class Course extends Eloquent {

	protected $table = 'courses';
	public $timestamps = true;
	protected $fillable = array('title', 'summary', 'description', 'language_id', 'skill_level', 'published_at', 'free', 'price', 'instractor_id', 'image', 'sub_category_id', 'congratulations_message', 'welcome_message');

	public function instractor()
	{
		return $this->belongsTo('App\Models\Instractors');
	}

	public function contents()
	{
		return $this->hasMany('App\Models\Content');
	}

	public function requirements()
	{
		return $this->hasMany('App\Models\Requierment');
	}

	public function objectives()
	{
		return $this->hasMany('App\Models\Opjective');
	}

	public function leactures()
	{
		return $this->hasMany('App\Models\Leacture');
	}

	public function subCategory()
	{
		return $this->belongsTo('App\Models\SubCategory');
	}

	public function language()
	{
		return $this->belongsTo('App\Models\Language');
	}

	public function studentReview()
	{
		return $this->belongsToMany('App\Models\Student', 'student_review');
	}

	public function studentWishlist()
	{
		return $this->belongsToMany('App\Models\Student', 'wishlists');
	}

	public function inrollments()
	{
		return $this->belongsToMany('App\Models\Student', 'inrollments');
	}

	public function cartStudents()
	{
		return $this->belongsToMany('App\Models\Student', 'carts')->withPivot('price');
	}

	public function reports()
	{
		return $this->morphToMany('App\Models\Student', 'reportable');
	}

	public function reports()
	{
		return $this->morphToMany('App\Models\Student', 'reportable');
	}

}