<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sub_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('instractors', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('instractor_id')->references('id')->on('instractors')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('sub_category_id')->references('id')->on('sub_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('leactures', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('leactures', function(Blueprint $table) {
			$table->foreign('content_id')->references('id')->on('contents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('objectives', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('requierments', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('resources', function(Blueprint $table) {
			$table->foreign('leacture_id')->references('id')->on('leactures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student_review', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student_review', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wishlists', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('wishlists', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student_skill', function(Blueprint $table) {
			$table->foreign('skill_id')->references('id')->on('skills')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student_skill', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('skills', function(Blueprint $table) {
			$table->foreign('sub_category_id')->references('id')->on('sub_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student_leacture', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('student_leacture', function(Blueprint $table) {
			$table->foreign('leacture_id')->references('id')->on('leactures')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('course_id')->references('id')->on('courses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('sub_categories', function(Blueprint $table) {
			$table->dropForeign('sub_categories_category_id_foreign');
		});
		Schema::table('instractors', function(Blueprint $table) {
			$table->dropForeign('instractors_student_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_language_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_instractor_id_foreign');
		});
		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_sub_category_id_foreign');
		});
		Schema::table('leactures', function(Blueprint $table) {
			$table->dropForeign('leactures_course_id_foreign');
		});
		Schema::table('leactures', function(Blueprint $table) {
			$table->dropForeign('leactures_content_id_foreign');
		});
		Schema::table('objectives', function(Blueprint $table) {
			$table->dropForeign('objectives_course_id_foreign');
		});
		Schema::table('requierments', function(Blueprint $table) {
			$table->dropForeign('requierments_course_id_foreign');
		});
		Schema::table('contents', function(Blueprint $table) {
			$table->dropForeign('contents_course_id_foreign');
		});
		Schema::table('resources', function(Blueprint $table) {
			$table->dropForeign('resources_leacture_id_foreign');
		});
		Schema::table('student_review', function(Blueprint $table) {
			$table->dropForeign('student_review_student_id_foreign');
		});
		Schema::table('student_review', function(Blueprint $table) {
			$table->dropForeign('student_review_course_id_foreign');
		});
		Schema::table('wishlists', function(Blueprint $table) {
			$table->dropForeign('wishlists_course_id_foreign');
		});
		Schema::table('wishlists', function(Blueprint $table) {
			$table->dropForeign('wishlists_student_id_foreign');
		});
		Schema::table('student_skill', function(Blueprint $table) {
			$table->dropForeign('student_skill_skill_id_foreign');
		});
		Schema::table('student_skill', function(Blueprint $table) {
			$table->dropForeign('student_skill_student_id_foreign');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->dropForeign('enrollments_student_id_foreign');
		});
		Schema::table('enrollments', function(Blueprint $table) {
			$table->dropForeign('enrollments_course_id_foreign');
		});
		Schema::table('skills', function(Blueprint $table) {
			$table->dropForeign('skills_sub_category_id_foreign');
		});
		Schema::table('student_leacture', function(Blueprint $table) {
			$table->dropForeign('student_leacture_student_id_foreign');
		});
		Schema::table('student_leacture', function(Blueprint $table) {
			$table->dropForeign('student_leacture_leacture_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_student_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_course_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_student_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_order_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_course_id_foreign');
		});
		Schema::table('reports', function(Blueprint $table) {
			$table->dropForeign('reports_student_id_foreign');
		});
	}
}