<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestTable extends Migration {

	public function up()
	{
		Schema::create('request', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('mall_id')->nullable();
			$table->integer('country_id')->nullable();
			$table->timestamp('received_at')->nullable();
			$table->enum('status', array('completed', 'processing'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('request');
	}
}