<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRevenueReportTable extends Migration {

	public function up()
	{
		Schema::create('revenue_report', function(Blueprint $table) {
			$table->timestamps();
			$table->softDeletes();
			$table->increments('id');
			$table->datetime('date')->nullable();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
			$table->integer('sedan')->nullable();
			$table->integer('jeep')->nullable();
			$table->integer('vip')->nullable();
			$table->integer('vvip')->nullable();
			$table->double('subscription')->nullable();
			$table->integer('total_wash')->nullable();
			$table->double('total_money')->nullable();
			$table->double('expenses')->nullable();
			$table->double('net_sale')->nullable();
			$table->integer('p_seat')->nullable();
			$table->string('p_gear')->nullable();
			$table->integer('p_steering')->nullable();
			$table->integer('p_mat')->nullable();
			$table->integer('bag')->nullable();
			$table->integer('seat')->nullable();
			$table->integer('gear')->nullable();
			$table->integer('steering')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('revenue_report');
	}
}