<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Car extends Eloquent {

	protected $table = 'car';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar');

	public function countries()
	{
		return $this->belongsToMany('Country', 'car_country', 'car_id', 'country_id');
	}

}