<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Request extends Eloquent {

	protected $table = 'request';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'mall_id', 'country_id', 'received_at', 'status');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function mall()
	{
		return $this->belongsTo('Mall', 'mall_id');
	}

	public function request_items()
	{
		return $this->hasMany('RequestItem', 'request_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

}