<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->datetime('date')->nullable();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
			$table->integer('user_id')->nullable();
			$table->integer('service_id')->nullable();
			$table->string('car_number')->nullable();
			$table->enum('payment_method', array('cash', 'visa'))->nullable();
			$table->integer('discount_percent')->nullable();
			$table->double('total')->nullable();
			$table->string('status')->nullable();
			$table->integer('park_id')->nullable();
			$table->string('client_name')->nullable();
			$table->string('client_phone')->nullable();
			$table->boolean('is_client')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}