<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CategoryCountry extends Eloquent {

	protected $table = 'category_country';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'category_id');

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

}