<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PaymentMethod extends Eloquent {

	protected $table = 'payment_method';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'country_id');

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

}