<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StockIn extends Eloquent {

	protected $table = 'stock_in';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('supply_id', 'quantity', 'user_id', 'country_id', 'price', 'total', 'description_en', 'description_ar', 'bill_no');

	public function supply()
	{
		return $this->belongsTo('Supply', 'supply_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

}