<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Supply extends Eloquent {

	protected $table = 'supply';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'quantity', 'damaged', 'barcode', 'description_en', 'description_ar');

	public function countries()
	{
		return $this->belongsToMany('Country', 'supply_country', 'supply_id', 'country_id');
	}

}