<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Area extends Eloquent {

	protected $table = 'area';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('area', 'country_id');

	public function malls()
	{
		return $this->hasMany('Mall', 'area_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

}