<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CarCountry extends Eloquent {

	protected $table = 'car_country';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('car_id', 'country_id');

	public function car()
	{
		return $this->belongsTo('Car', 'car_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

}