<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ClientOrder extends Eloquent {

	protected $table = 'client_order';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'country_id', 'total', 'payment_method', 'status');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function products()
	{
		return $this->hasMany('OrderProduct', 'order_id');
	}

}