<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SupplyCountry extends Eloquent {

	protected $table = 'supply_country';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'supply_id');

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function supply()
	{
		return $this->belongsTo('Supply', 'supply_id');
	}

}