<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CoverPrice extends Model 
{

    protected $table = 'cover_price';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('country_id', 'service_id', 'cover_id', 'price');

    public function service()
    {
        return $this->belongsTo('Service', 'service_id');
    }

    public function cover()
    {
        return $this->belongsTo('Cover', 'cover_id');
    }

    public function country()
    {
        return $this->belongsTo('Country', 'country_id');
    }

}