<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RequestItem extends Model 
{

    protected $table = 'request_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('request_id', 'supply_id', 'quantity');

    public function request()
    {
        return $this->belongsTo('Request', 'request_id');
    }

    public function supply()
    {
        return $this->belongsTo('Supply', 'supply_id');
    }

}