<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStockInTable extends Migration {

	public function up()
	{
		Schema::create('stock_in', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('supply_id')->nullable();
			$table->integer('quantity')->nullable();
			$table->integer('user_id')->nullable();
			$table->string('country_id')->nullable();
			$table->double('price')->nullable();
			$table->double('total')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->string('bill_no')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('stock_in');
	}
}