<?php

namespace TourPackage;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TourPackage extends Model 
{

    protected $table = 'tour_package';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description', 'minimum_participant', 'maximum_participant');

    public function tourRoutes()
    {
        return $this->hasManyThrough('FactoryRoute', 'tour_route');
    }

}